% SPLITTRNTST Divides the rss measurements data into a training set and a
% test set accoding to a specific configuration.
%
%	[TRNDATA,TSTDATA] = SPLITTRNTST(DATA, CONFIGURATION) splits DATA into
%	TRNDATA and TSTDATA, according to CONFIGURATION.
%
%   See Also GETFILTERDEFS.
%
%   Copyright  2018 Universitat Jaume I (UJI)

% Permission is hereby granted, free of charge, to any person obtaining a copy of
% this software and associated documentation files (the "Software"), to deal in
% the Software without restriction, including without limitation the rights to
% use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
% of the Software, and to permit persons to whom the Software is furnished to do
% so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all
% copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

function [rssTrnMat,rssTstMatrix,coorTrnMat,coorTstMat] = splitTrnTst(set,set,data,rssMatrix,coordMatrix)

% configuration = 1 -> Propoused split (among rp)
% configuration = 0 -> Random split (among rp)
c = cvpartition(set.nRP,'HoldOut',0.10);

% Output matrix are crated
rssTrnMat = zeros(set.nRP,set.nBeacons);


end

